package ca.queensu.cs.mase.generator;

import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Dummy printer for Capsule.java
 * @author Keith
 */
@SuppressWarnings("all")
public class CommonCapsuleGenerator {
  public CharSequence compile() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import java.util.*;");
    _builder.newLine();
    _builder.append("import java.util.concurrent.*;");
    _builder.newLine();
    _builder.append("import java.time.*;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Base class for capsules.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* This is part of the runtime for Urml codegen.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public abstract class Capsule implements Runnable {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// global variable to determine when to exit");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static volatile boolean EXIT = false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Capsule parent;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public List<MessagePort> internalports;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public List<MessagePort> externalports;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public List<Capsule> capsules;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public List<Connector> connectors;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* A message queue to keep track of messages sent by");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* other action code.  Will be checked against with");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* candidate transition to see if the transition\'s ");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* trigger message and the head of the queue match.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Queue<Message> queue = new LinkedBlockingQueue<>();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* A map that stores the timers that is currently");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* available.  Will be checked against with ");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* candidate transition to see if the specified");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* timer in the transition\'s trigger has timed out.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Map<TimerPort, Instant> instants = new HashMap<>();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Lock used for synchronized blocks");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected static Object lock = new Object();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String name = \"root\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* A dummy state");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public State currentState = new State(\"_NO_STATE\",");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("() -> { throw new IllegalArgumentException(); },");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("() -> { throw new IllegalArgumentException(); });");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Starts the capsule and all its children capsules");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (Capsule c: capsules) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new Thread(c).start();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("launch();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* The main loop of the capsule.  ");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void launch() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// start the initial transition first");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("startInit();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("while (!EXIT) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// find all possible transitions that is outgoing ");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// from the current state");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("List<? extends Transition> generated = findPossibleTrans();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// filter out with enabled transitions remaining in the list");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("List<? extends Transition> found = findNextTransitions(generated);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// if no enabled transition found, redo the loop");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (found == null || found.size() == 0) continue;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// if more than one transition is found, choose the first transition");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Transition t = found.get(0);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// if received message trigger, get the parameter");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("List<? extends CommonObj> param;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (t.triggerIn != null && t.triggerIn.size() != 0) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("Message m = queue.poll();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (m == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("param = new ArrayList<>();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("param = m.parameters;");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("param = new ArrayList<>();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// execute the transition and return whether to exit");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("boolean toExit = transitionAndIfFinal(t, param);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (toExit) EXIT = true;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Starts the initial transition chain.  Will also start with");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* initial transitions of sub-state machines.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public abstract void startInit();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Find all the possible transition (i.e. outgoing transitions)");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* from the current state.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @return a list of all the outgoing transitions from the");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*         current state");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public abstract List<? extends Transition> findPossibleTrans();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Find the enabled transitions for the capsule.  A transition");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* is enabled if and only if (1) its guard condition is true, and");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* (2) (a) it does not have any trigger, or (b) it has a message");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* trigger that matches the trigger from the head of the capsule\'s");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* message queue, or (c) its timer trigger has timed out.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @param possibleTrans the outgoing transitions from");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*        the current state");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @return enabled transitions from the current state");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private List<? extends Transition> findNextTransitions(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("List<? extends Transition> possibleTrans) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// check guard conditions");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("List<Transition> guardTrans = new ArrayList<>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (Transition t : possibleTrans)");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (t.guard.get())");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("guardTrans.add(t);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (guardTrans.size() == 0) return new ArrayList<>();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// check message queue and look for matching trigger");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// in the candidate transition");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Message m = queue.peek();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("List<Transition> inQueueTrans = new ArrayList<>();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (Transition t : guardTrans) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (t.triggerIn.size() == 0 && t.timerPort == null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("inQueueTrans.add(t);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("for (TriggerIn ti : t.triggerIn) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (m != null && m.port == ti.port && m.signal == ti.signal) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("inQueueTrans.add(t);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// find timers that have timed out");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (Transition t : guardTrans) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (t.timerPort != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (instants.containsKey(t.timerPort)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("Instant instant = instants.get(t.timerPort);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("if (Instant.now().isAfter(instant)) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("instants.remove(t.timerPort);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t");
    _builder.append("inQueueTrans.add(t);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return inQueueTrans;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Perform the specified transition.  The error in which the current state is not a \"from\"");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* state of the transition is not checked.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @param t specified transition to be executed");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @param params the parameter for the action code for t");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @return a boolean that determines if the destination state is final");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public abstract boolean transitionAndIfFinal(Transition t, List<? extends CommonObj> params);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Send the message to the current capsule by adding it to the current capsule\'s");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* message queue.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @param m the message");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void sendMessage(Message m) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("queue.add(m);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Pass message from message port p with the message");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* m");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @param p the port from which the message is sent");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @param m the message");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected void passMessage(MessagePort p, Message m) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (internalports.contains(p)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("Connector conn = findConnector(this, p);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (conn == null) throw new ConnectorNotFoundInCapsuleException();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("CapsulePortPair pr = findTarget(conn, this, p);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("pr.cap.passMessageIn(pr.port, m);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else if (externalports.contains(p)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("passMessageOut(p, m);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void passMessageOut(MessagePort p, Message m) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// assert externalports.contains(p)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (parent == null) throw new ExternalPortInRootCapsuleException();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Connector conn = parent.findConnector(this, p);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (conn == null) throw new ConnectorNotFoundInCapsuleException();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("CapsulePortPair pr = parent.findTarget(conn, this, p);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (pr.cap != parent) ");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("pr.cap.passMessageIn(pr.port, m);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("else");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("pr.cap.passMessageOut(pr.port, m);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private void passMessageIn(MessagePort p, Message m) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// assert externalports.contains(p)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Connector conn = findConnector(this, p);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (conn == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("m.port = p;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("sendMessage(m);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("CapsulePortPair pr = findTarget(conn, this, p);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("pr.cap.passMessageIn(pr.port, m);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private Connector findConnector(Capsule c, MessagePort p) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (Connector conn : connectors) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (conn.cap1 == c && conn.port1 == p ||");
    _builder.newLine();
    _builder.append("\t\t\t    ");
    _builder.append("conn.cap2 == c && conn.port2 == p)");
    _builder.newLine();
    _builder.append("\t\t\t    \t");
    _builder.append("return conn;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null; ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private CapsulePortPair findTarget(Connector conn, Capsule c, MessagePort p) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("CapsulePortPair result = new CapsulePortPair();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (conn.cap1 == c && conn.port1 == p) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result.cap = conn.cap2;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result.port = conn.port2;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else if (conn.cap2 == c && conn.port2 == p) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result.cap = conn.cap1;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result.port = conn.port1;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throw new ConnectorInconsistentException();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public class ConnectorNotFoundInCapsuleException extends RuntimeException {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public class ExternalPortInRootCapsuleException extends RuntimeException {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public class ConnectorInconsistentException extends RuntimeException {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public class CurrentStateIsNotSourceStateInTransitionException extends RuntimeException {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
