package ca.queensu.cs.mase.generator.capsules.constructors;

import ca.queensu.cs.mase.urml.Capsule;
import ca.queensu.cs.mase.urml.CapsuleInst;
import ca.queensu.cs.mase.urml.Connector;
import ca.queensu.cs.mase.urml.Port;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class CapsuleRegisterGenerator {
  private Capsule cap;
  
  public CapsuleRegisterGenerator(final Capsule cap) {
    this.cap = cap;
  }
  
  public CharSequence generate() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _registerPorts = this.registerPorts();
    _builder.append(_registerPorts);
    _builder.newLineIfNotEmpty();
    CharSequence _registerCapsuleInsts = this.registerCapsuleInsts();
    _builder.append(_registerCapsuleInsts);
    _builder.newLineIfNotEmpty();
    CharSequence _registerConnectors = this.registerConnectors();
    _builder.append(_registerConnectors);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Lists of message ports
   * @return generated code
   */
  public CharSequence registerPorts() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("internalports = Arrays.asList(");
    {
      EList<Port> _internalPorts = this.cap.getInternalPorts();
      boolean _hasElements = false;
      for(final Port port : _internalPorts) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        _builder.append("_p_");
        String _name = port.getName();
        _builder.append(_name);
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("externalports = Arrays.asList(");
    {
      EList<Port> _interfacePorts = this.cap.getInterfacePorts();
      boolean _hasElements_1 = false;
      for(final Port port_1 : _interfacePorts) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        _builder.append("_p_");
        String _name_1 = port_1.getName();
        _builder.append(_name_1);
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * List of capsule instances that the current capsule has
   * @return generated code
   */
  public CharSequence registerCapsuleInsts() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("capsules = Arrays.asList(");
    {
      EList<CapsuleInst> _capsuleInsts = this.cap.getCapsuleInsts();
      boolean _hasElements = false;
      for(final CapsuleInst ci : _capsuleInsts) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        _builder.append("_ci_");
        String _name = ci.getName();
        _builder.append(_name);
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    {
      EList<CapsuleInst> _capsuleInsts_1 = this.cap.getCapsuleInsts();
      for(final CapsuleInst ci_1 : _capsuleInsts_1) {
        _builder.append("_ci_");
        String _name_1 = ci_1.getName();
        _builder.append(_name_1);
        _builder.append(".name = \"");
        String _name_2 = ci_1.getName();
        _builder.append(_name_2);
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * List of connectors
   * @return generated code
   */
  public CharSequence registerConnectors() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("connectors = Arrays.asList(");
    _builder.newLine();
    {
      EList<Connector> _connectors = this.cap.getConnectors();
      boolean _hasElements = false;
      for(final Connector conn : _connectors) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String c1 = this.ciName(conn.getCapsuleInst1());
        String c2 = this.ciName(conn.getCapsuleInst2());
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("new Connector(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// capsule 1, port 1");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(c1, "\t\t");
        _builder.append(", ");
        _builder.append(c1, "\t\t");
        _builder.append("._p_");
        String _name = conn.getPort1().getName();
        _builder.append(_name, "\t\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// capsule 2, port 2");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(c2, "\t\t");
        _builder.append(", ");
        _builder.append(c2, "\t\t");
        _builder.append("._p_");
        String _name_1 = conn.getPort2().getName();
        _builder.append(_name_1, "\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  private String ciName(final CapsuleInst c) {
    String _xifexpression = null;
    if ((c == null)) {
      _xifexpression = "this";
    } else {
      String _name = c.getName();
      _xifexpression = ("_ci_" + _name);
    }
    return _xifexpression;
  }
}
