package ca.queensu.cs.mase.generator.capsules.constructors;

import ca.queensu.cs.mase.generator.capsules.constructors.CapsuleRegisterGenerator;
import ca.queensu.cs.mase.urml.Capsule;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class ConstructorGenerator {
  private Capsule cap;
  
  public ConstructorGenerator(final Capsule cap) {
    this.cap = cap;
  }
  
  public CharSequence generate() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _constructors = this.constructors();
    _builder.append(_constructors);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Constructors
   * @return generated code
   */
  private CharSequence constructors() {
    StringConcatenation _builder = new StringConcatenation();
    CapsuleRegisterGenerator reg = new CapsuleRegisterGenerator(this.cap);
    _builder.newLineIfNotEmpty();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Call this constructor when the capsule is a root");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public _C_");
    String _name = this.cap.getName();
    _builder.append(_name);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this(null);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Call this constructor when the capsule is not a");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* root");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @param parent_ the parent of the capsule");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public _C_");
    String _name_1 = this.cap.getName();
    _builder.append(_name_1);
    _builder.append("(Capsule parent) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.parent = parent;");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generate = reg.generate();
    _builder.append(_generate, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
