package ca.queensu.cs.mase.generator.capsules.members;

import ca.queensu.cs.mase.generator.capsules.members.ListGenerator;
import ca.queensu.cs.mase.generator.capsules.members.StateDefineGenerator;
import ca.queensu.cs.mase.generator.capsules.members.TransitionDefineGenerator;
import ca.queensu.cs.mase.urml.Capsule;
import ca.queensu.cs.mase.urml.State_;
import ca.queensu.cs.mase.urml.Transition;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class MemberGenerator {
  private Capsule cap;
  
  private List<State_> allStates;
  
  private List<Transition> allTransitions;
  
  private Map<Transition, Integer> nonameTrans;
  
  public MemberGenerator(final Capsule capsule, final List<State_> state_s, final List<Transition> transitions, final Map<Transition, Integer> map) {
    this.cap = capsule;
    this.allStates = state_s;
    this.allTransitions = transitions;
    this.nonameTrans = map;
  }
  
  public CharSequence generate() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generate = new ListGenerator(this.cap).generate();
    _builder.append(_generate);
    _builder.newLineIfNotEmpty();
    CharSequence _generate_1 = new StateDefineGenerator(this.allStates).generate();
    _builder.append(_generate_1);
    _builder.newLineIfNotEmpty();
    CharSequence _generate_2 = new TransitionDefineGenerator(
      this.allTransitions, this.nonameTrans).generate();
    _builder.append(_generate_2);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
