package ca.queensu.cs.mase.generator.capsules.members;

import ca.queensu.cs.mase.generator.dispatchers.StatementGenerator;
import ca.queensu.cs.mase.urml.ActionCode;
import ca.queensu.cs.mase.urml.State_;
import ca.queensu.cs.mase.urml.Statement;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class StateDefineGenerator {
  private List<State_> allStates;
  
  public StateDefineGenerator(final List<State_> allStates) {
    this.allStates = allStates;
  }
  
  /**
   * A state
   * @return generated code
   */
  public CharSequence generate() {
    StringConcatenation _builder = new StringConcatenation();
    {
      for(final State_ s : this.allStates) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* A state with name: ");
        String _name = s.getName();
        _builder.append(_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("private State _state_");
        String _name_1 = s.getName();
        _builder.append(_name_1);
        _builder.append(" = new State(");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// name");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\"");
        String _name_2 = s.getName();
        _builder.append(_name_2, "\t");
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// entry code");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("() -> {");
        _builder.newLine();
        {
          ActionCode _entryCode = s.getEntryCode();
          boolean _tripleNotEquals = (_entryCode != null);
          if (_tripleNotEquals) {
            {
              ActionCode _entryCode_1 = null;
              if (s!=null) {
                _entryCode_1=s.getEntryCode();
              }
              EList<Statement> _statements = null;
              if (_entryCode_1!=null) {
                _statements=_entryCode_1.getStatements();
              }
              for(final Statement st : _statements) {
                _builder.append("\t\t");
                String _state = this.state(st);
                _builder.append(_state, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("},");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// exit code");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("() -> {");
        _builder.newLine();
        {
          ActionCode _exitCode = s.getExitCode();
          boolean _tripleNotEquals_1 = (_exitCode != null);
          if (_tripleNotEquals_1) {
            {
              ActionCode _exitCode_1 = null;
              if (s!=null) {
                _exitCode_1=s.getExitCode();
              }
              EList<Statement> _statements_1 = null;
              if (_exitCode_1!=null) {
                _statements_1=_exitCode_1.getStatements();
              }
              for(final Statement st_1 : _statements_1) {
                _builder.append("\t\t");
                String _state_1 = this.state(st_1);
                _builder.append(_state_1, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("});");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  /**
   * Compiles the statement
   * @param obj the statement
   * @return string expressing the statement
   */
  private String state(final EObject obj) {
    return new StatementGenerator().state(obj);
  }
}
