package ca.queensu.cs.mase.generator.capsules.methods;

import ca.queensu.cs.mase.generator.capsules.methods.ExecuteTransitionGenerator;
import ca.queensu.cs.mase.generator.capsules.methods.FindNextTransitionGenerator;
import ca.queensu.cs.mase.generator.capsules.methods.InitialTransitionGenerator;
import ca.queensu.cs.mase.urml.State_;
import ca.queensu.cs.mase.urml.Transition;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class MethodGenerator {
  private List<State_> allStates;
  
  private List<Transition> allTransitions;
  
  private Transition initialTransition;
  
  private Multimap<State_, Transition> outgoingTransitions;
  
  private Map<Transition, Integer> nonameTrans;
  
  public MethodGenerator(final List<State_> allStates, final List<Transition> allTransitions, final Transition initialTransition, final Multimap<State_, Transition> outgoingTransitions, final Map<Transition, Integer> nonameTrans) {
    this.allStates = allStates;
    this.allTransitions = allTransitions;
    this.initialTransition = initialTransition;
    this.outgoingTransitions = outgoingTransitions;
    this.nonameTrans = nonameTrans;
  }
  
  public CharSequence generate() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generate = new FindNextTransitionGenerator(this.allStates, 
      this.outgoingTransitions, this.nonameTrans).generate();
    _builder.append(_generate);
    _builder.newLineIfNotEmpty();
    CharSequence _generate_1 = new InitialTransitionGenerator(this.initialTransition, 
      this.nonameTrans).generate();
    _builder.append(_generate_1);
    _builder.newLineIfNotEmpty();
    CharSequence _generate_2 = new ExecuteTransitionGenerator(this.allTransitions, 
      this.nonameTrans).generate();
    _builder.append(_generate_2);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
