package hotpatching.animation;

import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;

public class Controller implements Initializable, TrafficCommandListener {

    @FXML
    private ImageView imageView;

    @FXML
    private Circle top;

    @FXML
    private Circle middle;

    @FXML
    private Circle bottom;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        File file = new File("assets/tl.jpg");
        Image image = new Image(file.toURI().toString());
        imageView.setImage(image);

        top.setFill(Color.TRANSPARENT);
        middle.setFill(Color.TRANSPARENT);
        bottom.setFill(Color.TRANSPARENT);

        Interpreter interpreter = new Interpreter();
        interpreter.setCommandListener(this);
        interpreter.start();

        SocketServer server = new SocketServer();
        server.setInterpreter(interpreter);
        server.start();
    }

    @Override
    public void onChangeColor(String id, String color) {
        top.setFill(Color.TRANSPARENT);
        middle.setFill(Color.TRANSPARENT);
        bottom.setFill(Color.TRANSPARENT);

        if(id.equals("top")) {
            top.setFill(Color.valueOf(color));
        } else if(id.equals("middle")) {
            middle.setFill(Color.valueOf(color));
        } else if(id.equals("bottom")) {
            bottom.setFill(Color.valueOf(color));
        }
    }
}
