package hotpatching.animation;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class Interpreter extends Thread {

	private BlockingQueue<String> queue  = new PriorityBlockingQueue<String>();
	boolean debug = false;
	
	private TrafficCommandListener listener;
	
	public Interpreter() {
		super();
	}

	public void setCommandListener(TrafficCommandListener listener) {
		this.listener = listener;
	}

	@Override
	public void run() {
		super.run();
			
		Timer timer = new Timer();
    	TimerTask myTask = new TimerTask() {
    	    @Override
    	    public void run() {
    	    	pollingEvents();	
    	    }
    	};
    	
    	timer.schedule(myTask, 200, 200);
	    		
	}
	
	public void pollingEvents() {
		String event;
    	
    	while ((event = queue.poll()) != null) {

			if (debug)
				System.out.println(event);

			String[] fields = event.split("[|]");

			if (fields.length < 7) {
				System.err.println("malformed event");
				continue;
			}

			String[] p = fields[6].split(";");
			Map<String, String> params = new HashMap<String, String>();

			for (String param : p) {
				String[] keyValue = param.split(":");
				params.put(keyValue[0], keyValue[1]);
			}

			String cmd = params.get("cmd");
			if (cmd == null)
				continue;

			if(cmd.equals("set_color")) {
				String id = params.get("id");
				String color = params.get("color");
				listener.onChangeColor(id, color);
			}
		}
	}

	public void pushEvent(String event) {
		if (!queue.offer(event))
			System.out.println("Impossible to insert into queue");
	}
}
